<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-04-08 10:32
 */
interface StagestepDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Stagestep 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param stagestep primary key
 	 */
	public function delete($stagestepId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Stagestep stagestep
 	 */
	public function insert($stagestep);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Stagestep stagestep
 	 */
	public function update($stagestep);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByStageId($value);

	public function queryByStepno($value);

	public function queryByOperationId($value);


	public function deleteByStageId($value);

	public function deleteByStepno($value);

	public function deleteByOperationId($value);


}
?>